/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.kintai.dto.MSyukkinboDto;

public class AttendanceCheckCardVo extends AttendanceMenuVo {

	private static final long serialVersionUID = -1881098247641817291L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/kintai/attendanceCheckCard.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/attendanceCheckCard.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/attendanceCheckCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.NAM_CHECK_ATTENDANCE;

	// p[^
	public static final String PRM_TXT_START_HOUR 		= "txtStartHour"		;
	public static final String PRM_TXT_START_MIN 			= "txtStartMin"			;
	public static final String PRM_PLT_WORK_TYPE 			= "pltWorkType"			;
	public static final String PRM_PLT_START_HALF_HOLIDAY = "pltStartHalfHoliday"	;
	public static final String PRM_PLT_WORK_ON_HOLIDAY 	= "pltWorkOnHoliday"	;

	public static final String PRM_TXT_LATE_HOUR 			= "txtLateHour"			;
	public static final String PRM_TXT_LATE_MIN 			= "txtLateMin"			;
	public static final String PRM_PLT_LATE_REASON 		= "pltLateReason"		;
	public static final String PRM_PLT_LATE_CERTIFICATE 	= "pltLateCertificate"	;
	public static final String PRM_TXT_LATE_COMMENT 		= "txtLateComment"		;

	public static final String PRM_TXT_QUIT_HOUR 			= "txtQuitHour"			;
	public static final String PRM_TXT_QUIT_MIN 			= "txtQuitMin"			;
	public static final String PRM_PLT_QUIT_HALF_HOLIDAY 	= "pltQuitHalfHoliday"	;
	public static final String PRM_TXT_WORK_HOUR 			= "txtWorkHour"			;
	public static final String PRM_TXT_WORK_MIN 			= "txtWorkMin"			;
	public static final String PRM_TXT_BREAK_HOUR 		= "txtBreakHour"		;
	public static final String PRM_TXT_BREAK_MIN 			= "txtBreakMin"			;
	public static final String PRM_LBL_ACTUAL_HOUR		= "lblActualHour"		;
	public static final String PRM_LBL_ACTUAL_MIN			= "lblActualMin"		;

	public static final String PRM_PLT_LEAVE_EARLY_REASON			= "pltLeaveEarlyReason"		;
	public static final String PRM_TXT_LEAVE_EARLY_HOUR			= "txtLeaveEarlyHour"		;
	public static final String PRM_TXT_LEAVE_EARLY_MIN			= "txtLeaveEarlyMin"		;
	public static final String PRM_PLT_LEAVE_EARLY_CERTIFICATE 	= "pltLeaveEarlyCertificate";
	public static final String PRM_TXT_LEAVE_EARLY_COMMENT 		= "txtLeaveEarlyComment"	;

	public static final String PRM_TXT_OVER_HOUR 				= "txtOverHour"				;
	public static final String PRM_TXT_OVER_MIN 				= "txtOverMin"				;
	public static final String PRM_TXT_WORK_ON_HOLIDAY_HOUR 	= "txtWorkOnHolidayHour"	;
	public static final String PRM_TXT_WORK_ON_HOLIDAY_MIN 	= "txtWorkOnHolidayMin"		;
	public static final String PRM_TXT_LATE_NIGHT_HOUR 		= "txtLateNightHour"		;
	public static final String PRM_TXT_LATE_NIGHT_MIN 		= "txtLateNightMin"			;

	public static final String PRM_CKB_SYOKUJI 	= "ckbSyokuji"	;
	public static final String PRM_CKB_CYOKU1 	= "ckbCyoku1"	;	
	public static final String PRM_CKB_CYOKU2 	= "ckbCyoku2"	;
	public static final String PRM_CKB_CYOKU3 	= "ckbCyoku3"	;
	public static final String PRM_CKB_HOKA1		= "ckbHoka1"	;
	public static final String PRM_CKB_HOKA2		= "ckbHoka2"	;
	public static final String PRM_CKB_HOKA3	 	= "ckbHoka3"	;
	public static final String PRM_CKB_HOKA4		= "ckbHoka4"	;
	public static final String PRM_CKB_HOKA5		= "ckbHoka5"	;

	public static final String PRM_LBL_APPROVAL_COMMENT 	= "lblApprovalComment"	;

	// tB[hyѐ
	public static final String NAM_START_TIME				= CommonConst.NAM_START_TIME + CommonConst.NAM_TIME;
	public static final String NAM_START_TIME_HOUR		= CommonConst.NAM_START_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_START_TIME_MIN			= CommonConst.NAM_START_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_WORKING_TYPE			= CommonConst.NAM_WORKING_TYPE;
	public static final String NAM_START_HALF_HOLIDAY		= CommonConst.NAM_START_TIME + CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_TYPE;
	public static final String NAM_WORK_ON_HOLIDAY		= CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_TYPE;

	public static final String NAM_LATE_TIME				= CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LATE_TIME_HOUR			= CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_LATE_TIME_MIN			= CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_LATE_REASON			= CommonConst.NAM_ARRIVE_LATE + CommonConst.NAM_REASON;
	public static final String NAM_LATE_CERTIFICATE		= CommonConst.NAM_CERTIFICATE;
	public static final String NAM_LATE_COMMENT 			= CommonConst.NAM_COMMENT;

	public static final String NAM_QUIT_TIME				= CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME;
	public static final String NAM_QUIT_TIME_HOUR 		= CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_QUIT_TIME_MIN 			= CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_QUIT_HALF_HOLIDAY		= CommonConst.NAM_QUIT_TIME	+ CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_TYPE;
	public static final String NAM_WORKING_TIME			= CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_WORKING_TIME_HOUR 		= CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_WORKING_TIME_MIN 		= CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_INTERVAL_TIME			= CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_INTERVAL_TIME_HOUR 	= CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_INTERVAL_TIME_MIN 		= CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_ACTUAL_WORK_TIME		= CommonConst.NAM_ACTUAL_WORK_TIME + CommonConst.NAM_COMMON_TIME;

	public static final String NAM_LEAVE_EARLY_REASON			= CommonConst.NAM_LEAVE_EARLY 	+ CommonConst.NAM_REASON;
	public static final String NAM_LEAVE_EARLY_TIME			= CommonConst.NAM_LEAVE_EARLY 	+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LEAVE_EARLY_TIME_HOUR		= CommonConst.NAM_LEAVE_EARLY 	+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_LEAVE_EARLY_TIME_MIN		= CommonConst.NAM_LEAVE_EARLY 	+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_LEAVE_EARLY_CERTIFICATE	= CommonConst.NAM_CERTIFICATE;
	public static final String NAM_LEAVE_EARLY_COMMENT 		= CommonConst.NAM_COMMENT;

	public static final String NAM_OVER_TIME				= CommonConst.NAM_OVERTIME 			+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_OVER_TIME_HOUR			= CommonConst.NAM_OVERTIME 			+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_OVER_TIME_MIN			= CommonConst.NAM_OVERTIME 			+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_WORK_ON_HOLIDAY_TIME 	= CommonConst.NAM_WORK_ON_HOLIDAY 	+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_WORK_ON_HOLIDAY_HOUR 	= CommonConst.NAM_WORK_ON_HOLIDAY 	+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_WORK_ON_HOLIDAY_MIN 	= CommonConst.NAM_WORK_ON_HOLIDAY 	+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_LATE_NIGHT 			= CommonConst.NAM_LATE_NIGHT 		+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LATE_NIGHT_HOUR 		= CommonConst.NAM_LATE_NIGHT 		+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_LATE_NIGHT_MIN 		= CommonConst.NAM_LATE_NIGHT 		+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;

	public static final String NAM_ALLOWANCE 			= CommonConst.NAM_ALLOWANCE;

	public static final String NAM_APPROVAL_COMMENT 	= CommonConst.NAM_APPROVED + CommonConst.NAM_COMMENT;

	public static final int	LEN_HOUR  		= CommonConst.LEN_TIME_HOUR;
	public static final int	LEN_MIN  		= CommonConst.LEN_TIME_MIN;
	public static final int	LEN_COMMENT		= 50;

	// tB[h	
	private String txtStartHour;
	private String txtStartMin;
	private String pltWorkType;
	private String pltStartHalfHoliday;
	private String pltWorkOnHoliday;

	private String txtLateHour;
	private String txtLateMin;
	private String pltLateReason;
	private String pltLateCertificate;
	private String txtLateComment;

	private String txtQuitHour;
	private String txtQuitMin;
	private String pltQuitHalfHoliday;
	private String txtWorkHour;
	private String txtWorkMin;
	private String txtBreakHour;
	private String txtBreakMin;
	private String lblActualHour;
	private String lblActualMin;

	private String pltLeaveEarlyReason;
	private String txtLeaveEarlyHour;
	private String txtLeaveEarlyMin;
	private String pltLeaveEarlyCertificate;
	private String txtLeaveEarlyComment;

	private String txtOverHour;
	private String txtOverMin;
	private String txtWorkOnHolidayHour;
	private String txtWorkOnHolidayMin;
	private String txtLateNightHour;
	private String txtLateNightMin;

	private String ckbSyokuji;
	private String ckbCyoku1;
	private String ckbCyoku2;
	private String ckbCyoku3;
	private String ckbHoka1;
	private String ckbHoka2;
	private String ckbHoka3;
	private String ckbHoka4;
	private String ckbHoka5;

	private String lblApprovalComment;

	// 蓖
	public String[][] aryAllowance;

	// v_EXg
	public String[][] aryPltWorkType;
	public String[][] aryPltStartHalfHoliday;
	public String[][] aryPltQuitHalfHoliday;
	public String[][] aryPltWorkOnHoliday;
	public String[][] aryPltLateReason;
	public String[][] aryPltLateCertificate;
	public String[][] aryPltLeaveEarlyReason;
	public String[][] aryPltLeaveEarlyCertificate;

	/**
	 * RXgN^
	 */
	public AttendanceCheckCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		mode = MODE_EDIT;
		aryAllowance = new String[0][0];
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		txtStartHour 		= request.getParameter(PRM_TXT_START_HOUR);
		txtStartMin 		= request.getParameter(PRM_TXT_START_MIN);
		pltWorkType 		= request.getParameter(PRM_PLT_WORK_TYPE);
		pltStartHalfHoliday = request.getParameter(PRM_PLT_START_HALF_HOLIDAY);
		pltWorkOnHoliday 	= request.getParameter(PRM_PLT_WORK_ON_HOLIDAY);
		txtLateHour			= request.getParameter(PRM_TXT_LATE_HOUR);
		txtLateMin			= request.getParameter(PRM_TXT_LATE_MIN);
		pltLateReason		= request.getParameter(PRM_PLT_LATE_REASON);
		pltLateCertificate	= request.getParameter(PRM_PLT_LATE_CERTIFICATE);
		txtLateComment		= request.getParameter(PRM_TXT_LATE_COMMENT);

		txtQuitHour 		= request.getParameter(PRM_TXT_QUIT_HOUR);
		txtQuitMin 			= request.getParameter(PRM_TXT_QUIT_MIN);
		pltQuitHalfHoliday	= request.getParameter(PRM_PLT_QUIT_HALF_HOLIDAY);
		txtWorkHour 		= request.getParameter(PRM_TXT_WORK_HOUR);
		txtWorkMin 			= request.getParameter(PRM_TXT_WORK_MIN);
		txtBreakHour		= request.getParameter(PRM_TXT_BREAK_HOUR);
		txtBreakMin			= request.getParameter(PRM_TXT_BREAK_MIN);

		pltLeaveEarlyReason			= request.getParameter(PRM_PLT_LEAVE_EARLY_REASON);
		txtLeaveEarlyHour 			= request.getParameter(PRM_TXT_LEAVE_EARLY_HOUR);
		txtLeaveEarlyMin 			= request.getParameter(PRM_TXT_LEAVE_EARLY_MIN);
		pltLeaveEarlyCertificate	= request.getParameter(PRM_PLT_LEAVE_EARLY_CERTIFICATE);
		txtLeaveEarlyComment		= request.getParameter(PRM_TXT_LEAVE_EARLY_COMMENT);

		txtOverHour				= request.getParameter(PRM_TXT_OVER_HOUR);
		txtOverMin				= request.getParameter(PRM_TXT_OVER_MIN);
		txtWorkOnHolidayHour	= request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		txtWorkOnHolidayMin		= request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_MIN);
		txtLateNightHour		= request.getParameter(PRM_TXT_LATE_NIGHT_HOUR);
		txtLateNightMin			= request.getParameter(PRM_TXT_LATE_NIGHT_MIN);

		ckbSyokuji 	= getCheckBoxParam(request.getParameter(PRM_CKB_SYOKUJI));
		ckbCyoku1 	= getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU1));
		ckbCyoku2 	= getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU2));
		ckbCyoku3 	= getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU3));
		ckbHoka1 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA1));
		ckbHoka2 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA2));
		ckbHoka3 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA3));
		ckbHoka4 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA4));
		ckbHoka5 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA5));

	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MSyukkinboDto dto) {
		txtStartHour 		= util.convStringTimeToStringHour(dto.getSyJikoku());
		txtStartMin			= util.convStringTimeToStringMinutes(dto.getSyJikoku());
		pltWorkType  		= dto.getKinmu();
		pltStartHalfHoliday = dto.getSHankyuKb();
		pltWorkOnHoliday  	= dto.getKyusyuKb();

		txtLateHour 		= String.valueOf(util.convIntegerTimeToStringHour(dto.getTiJikan()));
		txtLateMin 			= String.valueOf(util.convIntegerTimeToStringMinutes(dto.getTiJikan()));
		pltLateReason 		= dto.getTiRiyuu();
		pltLateCertificate 	= dto.getTiSyoumei();
		txtLateComment 		= dto.getTiComent();
		txtQuitHour 		= util.convStringTimeToStringHour(dto.getTaJikoku());
		txtQuitMin			= util.convStringTimeToStringMinutes(dto.getTaJikoku());
		pltQuitHalfHoliday	= dto.getTHankyuKb();
		txtWorkHour  		= util.convIntegerTimeToStringHour(dto.getKinmuJi());
		txtWorkMin  		= util.convIntegerTimeToStringMinutes(dto.getKinmuJi());
		txtBreakHour 		= util.convIntegerTimeToStringHour(dto.getKyukeiJi());
		txtBreakMin 		= util.convIntegerTimeToStringMinutes(dto.getKyukeiJi());

		pltLeaveEarlyReason 		= dto.getSoRiyuu();
		txtLeaveEarlyHour 			= util.convIntegerTimeToStringHour(dto.getSoJikan());
		txtLeaveEarlyMin 			= util.convIntegerTimeToStringMinutes(dto.getSoJikan());
		pltLeaveEarlyCertificate 	= dto.getSoSyoumei();
		txtLeaveEarlyComment 		= dto.getSoComent();

		txtOverHour 				= util.convIntegerTimeToStringHour(dto.getZaJikan());
		txtOverMin 					= util.convIntegerTimeToStringMinutes(dto.getZaJikan());
		txtWorkOnHolidayHour 		= util.convIntegerTimeToStringHour(dto.getKsJikan());
		txtWorkOnHolidayMin 		= util.convIntegerTimeToStringMinutes(dto.getKsJikan());
		txtLateNightHour			= util.convIntegerTimeToStringHour(dto.getSnJikan());
		txtLateNightMin				= util.convIntegerTimeToStringMinutes(dto.getSnJikan());

		ckbSyokuji 	= String.valueOf(dto.getSyokuji());
		ckbCyoku1 	= String.valueOf(dto.getCyoku1());
		ckbCyoku2 	= String.valueOf(dto.getCyoku2());
		ckbCyoku3 	= String.valueOf(dto.getCyoku3());
		ckbHoka1 	= String.valueOf(dto.getHoka1());
		ckbHoka2 	= String.valueOf(dto.getHoka2());
		ckbHoka3 	= String.valueOf(dto.getHoka3());
		ckbHoka4 	= String.valueOf(dto.getHoka4());
		ckbHoka5 	= String.valueOf(dto.getHoka5());

	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	@Override
	public void setDtoFields(MSyukkinboDto dto) {
		super.setDtoFields(dto);
		dto.setSyJikoku(util.convStringTimeFormatted(txtStartHour, txtStartMin));
		dto.setKinmu(pltWorkType);
		dto.setSHankyuKb(pltStartHalfHoliday);
		dto.setKyusyuKb(pltWorkOnHoliday);
		dto.setTiJikan(util.convStringTimeToIntegerTime(txtLateHour, txtLateMin));
		dto.setTiRiyuu(pltLateReason);
		dto.setTiSyoumei(pltLateCertificate);
		dto.setTiComent(txtLateComment);

		dto.setTaJikoku(util.convStringTimeFormatted(txtQuitHour, txtQuitMin));
		dto.setTHankyuKb(pltQuitHalfHoliday);
		dto.setKinmuJi(util.convStringTimeToIntegerTime(txtWorkHour, txtWorkMin));
		dto.setKyukeiJi(util.convStringTimeToIntegerTime(txtBreakHour, txtBreakMin));
		dto.setSoRiyuu(pltLeaveEarlyReason);
		dto.setSoJikan(util.convStringTimeToIntegerTime(txtLeaveEarlyHour, txtLeaveEarlyMin));
		dto.setSoSyoumei(pltLeaveEarlyCertificate);
		dto.setSoComent(txtLeaveEarlyComment);
		dto.setZaJikan(util.convStringTimeToIntegerTime(txtOverHour, txtOverMin));
		dto.setKsJikan(util.convStringTimeToIntegerTime(txtWorkOnHolidayHour, txtWorkOnHolidayMin));
		dto.setSnJikan(util.convStringTimeToIntegerTime(txtLateNightHour, txtLateNightMin));
		dto.setSyokuji(Integer.parseInt(ckbSyokuji));
		dto.setCyoku1(Integer.parseInt(ckbCyoku1));
		dto.setCyoku2(Integer.parseInt(ckbCyoku2));
		dto.setCyoku3(Integer.parseInt(ckbCyoku3));
		dto.setHoka1(Integer.parseInt(ckbHoka1));
		dto.setHoka2(Integer.parseInt(ckbHoka2));
		dto.setHoka3(Integer.parseInt(ckbHoka3));
		dto.setHoka4(Integer.parseInt(ckbHoka4));
		dto.setHoka5(Integer.parseInt(ckbHoka5));

		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		dto.setUpdtTimes(util.getDateTime(new Date()));
	}

	/**
	 * tB[h
	 */
	public void initFields() {
		Date nowDate = new Date();
		txtStartHour 			= String.valueOf(MospUtility.getHour(nowDate));
		txtStartMin 			= String.valueOf(MospUtility.getMinute(nowDate));
		pltWorkType 			= "";
		pltStartHalfHoliday 	= "";
		pltWorkOnHoliday 		= "";

		txtLateHour 			= "0";
		txtLateMin 				= "0";
		pltLateReason 			= "";
		pltLateCertificate 		= "";
		txtLateComment 			= "";

		txtQuitHour 			= String.valueOf(MospUtility.getHour(nowDate));
		txtQuitMin 				= String.valueOf(MospUtility.getMinute(nowDate));
		pltQuitHalfHoliday 		= "";
		txtWorkHour 			= "0";
		txtWorkMin 				= "0";
		txtBreakHour 			= "0";
		txtBreakMin 			= "0";

		pltLeaveEarlyReason 	= "";
		txtLeaveEarlyHour 		= "0";
		txtLeaveEarlyMin 		= "0";
		pltLeaveEarlyCertificate= "";
		txtLeaveEarlyComment 	= "";

		txtOverHour 			= "0";
		txtOverMin 				= "0";
		txtWorkOnHolidayHour 	= "0";
		txtWorkOnHolidayMin 	= "0";
		txtLateNightHour 		= "0";
		txtLateNightMin 		= "0";

		ckbSyokuji 				= "0";
		ckbCyoku1 				= "0";
		ckbCyoku2 				= "0";
		ckbCyoku3 				= "0";
		ckbHoka1 				= "0";
		ckbHoka2 				= "0";
		ckbHoka3 				= "0";
		ckbHoka4 				= "0";
		ckbHoka5 				= "0";
		lblApprovalComment 		= "";
	}

	/**
	 * x\ڃZbg
	 * @param dto	ΏDTO
	 */
	public void setLabelInfo(MSyukkinboDto dto) {
		// Ԃ̃Zbg
		//  = Ζ - xeԁicƋxeԊ܂ށj
		int actual = 0;
		if (dto.getKinmuJi() != 0) {
			actual = dto.getKinmuJi() - dto.getKyukeiJi();
		}
		setLblActualHour(util.convIntegerTimeToStringHour(actual));
		setLblActualMin(util.convIntegerTimeToStringMinutes(actual));
		lblApprovalComment = dto.getSnComent();
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtStartHour	, NAM_START_TIME	, PRM_TXT_START_HOUR);
		checkRequired(txtStartMin	, NAM_START_TIME	, PRM_TXT_START_MIN);
		checkRequired(txtLateHour	, NAM_LATE_TIME		, PRM_TXT_LATE_HOUR);
		checkRequired(txtLateMin	, NAM_LATE_TIME 	, PRM_TXT_LATE_MIN);

		checkRequired(txtQuitHour			, NAM_QUIT_TIME			, PRM_TXT_QUIT_HOUR);
		checkRequired(txtQuitMin			, NAM_QUIT_TIME			, PRM_TXT_QUIT_MIN);
		checkRequired(txtWorkHour			, NAM_WORKING_TIME		, PRM_TXT_WORK_HOUR);
		checkRequired(txtWorkMin			, NAM_WORKING_TIME 		, PRM_TXT_WORK_MIN);
		checkRequired(txtBreakHour			, NAM_INTERVAL_TIME		, PRM_TXT_BREAK_HOUR);
		checkRequired(txtBreakMin			, NAM_INTERVAL_TIME 	, PRM_TXT_BREAK_MIN);
		checkRequired(txtLeaveEarlyHour		, NAM_LEAVE_EARLY_TIME	, PRM_TXT_LEAVE_EARLY_HOUR);
		checkRequired(txtLeaveEarlyMin		, NAM_LEAVE_EARLY_TIME 	, PRM_TXT_LEAVE_EARLY_MIN);
		checkRequired(txtOverHour			, NAM_OVER_TIME			, PRM_TXT_OVER_HOUR);
		checkRequired(txtOverMin			, NAM_OVER_TIME 		, PRM_TXT_OVER_MIN);
		checkRequired(txtWorkOnHolidayHour	, NAM_WORK_ON_HOLIDAY	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkRequired(txtWorkOnHolidayMin	, NAM_WORK_ON_HOLIDAY 	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkRequired(txtLateNightHour		, NAM_LATE_NIGHT		, PRM_TXT_LATE_NIGHT_HOUR);
		checkRequired(txtLateNightMin		, NAM_LATE_NIGHT 		, PRM_TXT_LATE_NIGHT_MIN);

		// mF
		checkNumber(txtStartHour	, NAM_START_TIME	, PRM_TXT_START_HOUR);
		checkNumber(txtStartMin		, NAM_START_TIME	, PRM_TXT_START_MIN);
		checkNumber(txtLateHour		, NAM_LATE_TIME		, PRM_TXT_LATE_HOUR);
		checkNumber(txtLateMin		, NAM_LATE_TIME		, PRM_TXT_LATE_MIN);

		checkNumber(txtQuitHour			, NAM_QUIT_TIME			, PRM_TXT_QUIT_HOUR);
		checkNumber(txtQuitMin			, NAM_QUIT_TIME			, PRM_TXT_QUIT_MIN);
		checkNumber(txtWorkHour			, NAM_WORKING_TIME		, PRM_TXT_WORK_HOUR);
		checkNumber(txtWorkMin			, NAM_WORKING_TIME 		, PRM_TXT_WORK_MIN);
		checkNumber(txtBreakHour		, NAM_INTERVAL_TIME		, PRM_TXT_BREAK_HOUR);
		checkNumber(txtBreakMin			, NAM_INTERVAL_TIME 	, PRM_TXT_BREAK_MIN);
		checkNumber(txtLeaveEarlyHour	, NAM_LEAVE_EARLY_TIME	, PRM_TXT_LEAVE_EARLY_HOUR);
		checkNumber(txtLeaveEarlyMin	, NAM_LEAVE_EARLY_TIME 	, PRM_TXT_LEAVE_EARLY_MIN);
		checkNumber(txtOverHour			, NAM_OVER_TIME			, PRM_TXT_OVER_HOUR);
		checkNumber(txtOverMin			, NAM_OVER_TIME 		, PRM_TXT_OVER_MIN);
		checkNumber(txtWorkOnHolidayHour, NAM_WORK_ON_HOLIDAY	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkNumber(txtWorkOnHolidayMin	, NAM_WORK_ON_HOLIDAY 	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkNumber(txtLateNightHour	, NAM_LATE_NIGHT		, PRM_TXT_LATE_NIGHT_HOUR);
		checkNumber(txtLateNightMin		, NAM_LATE_NIGHT 		, PRM_TXT_LATE_NIGHT_MIN);

		// mF	
		checkLength(txtStartHour	, LEN_HOUR		, NAM_START_TIME	, PRM_TXT_START_HOUR);
		checkLength(txtStartMin		, LEN_MIN		, NAM_START_TIME	, PRM_TXT_START_MIN);
		checkLength(txtLateHour		, LEN_HOUR		, NAM_LATE_TIME		, PRM_TXT_LATE_HOUR);
		checkLength(txtLateMin		, LEN_MIN		, NAM_LATE_TIME		, PRM_TXT_LATE_MIN);
		checkLength(txtLateComment	, LEN_COMMENT	, NAM_LATE_COMMENT	, PRM_TXT_LATE_COMMENT);

		checkLength(txtQuitHour	, LEN_HOUR		, NAM_QUIT_TIME		, PRM_TXT_QUIT_HOUR);
		checkLength(txtQuitMin	, LEN_MIN		, NAM_QUIT_TIME		, PRM_TXT_QUIT_MIN);
		checkLength(txtWorkHour	, LEN_HOUR		, NAM_WORKING_TIME	, PRM_TXT_WORK_HOUR);
		checkLength(txtWorkMin	, LEN_MIN		, NAM_WORKING_TIME	, PRM_TXT_WORK_MIN);
		checkLength(txtBreakHour		, LEN_HOUR	, NAM_INTERVAL_TIME		, PRM_TXT_BREAK_HOUR);
		checkLength(txtBreakMin			, LEN_MIN	, NAM_INTERVAL_TIME 	, PRM_TXT_BREAK_MIN);
		checkLength(txtLeaveEarlyHour	, LEN_HOUR	, NAM_LEAVE_EARLY_TIME	, PRM_TXT_LEAVE_EARLY_HOUR);
		checkLength(txtLeaveEarlyMin	, LEN_MIN	, NAM_LEAVE_EARLY_TIME 	, PRM_TXT_LEAVE_EARLY_MIN);
		checkLength(txtOverHour			, LEN_HOUR	, NAM_OVER_TIME			, PRM_TXT_OVER_HOUR);
		checkLength(txtOverMin			, LEN_MIN	, NAM_OVER_TIME 		, PRM_TXT_OVER_MIN);
		checkLength(txtWorkOnHolidayHour, LEN_HOUR	, NAM_WORK_ON_HOLIDAY	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkLength(txtWorkOnHolidayMin	, LEN_MIN	, NAM_WORK_ON_HOLIDAY 	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkLength(txtLateNightHour	, LEN_HOUR	, NAM_LATE_NIGHT		, PRM_TXT_LATE_NIGHT_HOUR);
		checkLength(txtLateNightMin		, LEN_MIN	, NAM_LATE_NIGHT 		, PRM_TXT_LATE_NIGHT_MIN);

		checkLength(txtLeaveEarlyComment, LEN_COMMENT, NAM_LEAVE_EARLY_COMMENT, PRM_TXT_LEAVE_EARLY_COMMENT);

		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh	
	public String getTxtStartHour			() { return txtStartHour		; }
	public String getTxtStartMin			() { return txtStartMin			; }
	public String getPltWorkType			() { return pltWorkType			; }
	public String getPltStartHalfHoliday	() { return pltStartHalfHoliday	; }
	public String getPltWorkOnHoliday		() { return pltWorkOnHoliday	; }
	public String getTxtLateHour			() { return txtLateHour			; }
	public String getTxtLateMin				() { return txtLateMin			; }
	public String getPltLateReason			() { return pltLateReason		; }
	public String getPltLateCertificate		() { return pltLateCertificate	; }
	public String getTxtLateComment			() { return txtLateComment		; }

	public String getEscTxtStartHour		() { return escapeHTML(txtStartHour			); }
	public String getEscTxtStartMin			() { return escapeHTML(txtStartMin			); }
	public String getEscPltWorkType			() { return escapeHTML(pltWorkType			); }
	public String getEscPltStartHalfHoliday	() { return escapeHTML(pltStartHalfHoliday	); }
	public String getEscPltWorkOnHoliday	() { return escapeHTML(pltWorkOnHoliday		); }
	public String getEscTxtLateHour			() { return escapeHTML(txtLateHour			); }
	public String getEscTxtLateMin			() { return escapeHTML(txtLateMin			); }
	public String getEscPltLateReason		() { return escapeHTML(pltLateReason		); }
	public String getEscPltLateCertificate	() { return escapeHTML(pltLateCertificate	); }
	public String getEscTxtLateComment		() { return escapeHTML(txtLateComment		); }

	public String getTxtQuitHour		() { return txtQuitHour			; }
	public String getTxtQuitMin			() { return txtQuitMin			; }
	public String getPltQuitHalfHoliday	() { return pltQuitHalfHoliday	; }
	public String getTxtWorkHour		() { return txtWorkHour			; }
	public String getTxtWorkMin			() { return txtWorkMin			; }
	public String getTxtBreakHour		() { return txtBreakHour		; }
	public String getTxtBreakMin		() { return txtBreakMin			; }

	public String getPltLeaveEarlyReason		() { return pltLeaveEarlyReason			; }
	public String getTxtLeaveEarlyHour			() { return txtLeaveEarlyHour			; }
	public String getTxtLeaveEarlyMin			() { return txtLeaveEarlyMin			; }
	public String getPltLeaveEarlyCertificate	() { return pltLeaveEarlyCertificate	; }
	public String getTxtLeaveEarlyComment		() { return txtLeaveEarlyComment		; }

	public String getTxtOverHour			() { return txtOverHour				; }
	public String getTxtOverMin				() { return txtOverMin				; }
	public String getTxtWorkOnHolidayHour	() { return txtWorkOnHolidayHour	; }
	public String getTxtWorkOnHolidayMin	() { return txtWorkOnHolidayMin		; }
	public String getTxtLateNightHour		() { return txtLateNightHour		; }
	public String getTxtLateNightMin		() { return txtLateNightMin			; }

	public String getCkbSyokuji	() { return ckbSyokuji	; }
	public String getCkbCyoku1	() { return ckbCyoku1	; }
	public String getCkbCyoku2	() { return ckbCyoku2	; }
	public String getCkbCyoku3	() { return ckbCyoku3	; }
	public String getCkbHoka1	() { return ckbHoka1	; }
	public String getCkbHoka2	() { return ckbHoka2	; }
	public String getCkbHoka3	() { return ckbHoka3	; }
	public String getCkbHoka4	() { return ckbHoka4	; }
	public String getCkbHoka5	() { return ckbHoka5	; }

	public String getEscTxtQuitHour			() { return escapeHTML(txtQuitHour			); }
	public String getEscTxtQuitMin			() { return escapeHTML(txtQuitMin			); }
	public String getEscPltQuitHalfHoliday	() { return escapeHTML(pltQuitHalfHoliday	); }
	public String getEscTxtWorkHour			() { return escapeHTML(txtWorkHour			); }
	public String getEscTxtWorkMin			() { return escapeHTML(txtWorkMin			); }
	public String getEscTxtBreakHour		() { return escapeHTML(txtBreakHour			); }
	public String getEscTxtBreakMin			() { return escapeHTML(txtBreakMin			); }

	public String getEscPltLeaveEarlyReason			() { return escapeHTML(pltLeaveEarlyReason		); }
	public String getEscTxtLeaveEarlyHour			() { return escapeHTML(txtLeaveEarlyHour		); }
	public String getEscTxtLeaveEarlyMin			() { return escapeHTML(txtLeaveEarlyMin			); }
	public String getEscPltLeaveEarlyCertificate	() { return escapeHTML(pltLeaveEarlyCertificate	); }
	public String getEscTxtLeaveEarlyComment		() { return escapeHTML(txtLeaveEarlyComment		); }

	public String getEscTxtOverHour				() { return escapeHTML(txtOverHour			); }
	public String getEscTxtOverMin				() { return escapeHTML(txtOverMin			); }
	public String getEscTxtWorkOnHolidayHour	() { return escapeHTML(txtWorkOnHolidayHour	); }
	public String getEscTxtWorkOnHolidayMin		() { return escapeHTML(txtWorkOnHolidayMin	); }
	public String getEscTxtLateNightHour		() { return escapeHTML(txtLateNightHour		); }
	public String getEscTxtLateNightMin			() { return escapeHTML(txtLateNightMin		); }

	public String getEscCkbSyokuji	() { return getCheckBoxChecked(ckbSyokuji	); }
	public String getEscCkbCyoku1	() { return getCheckBoxChecked(ckbCyoku1	); }
	public String getEscCkbCyoku2	() { return getCheckBoxChecked(ckbCyoku2	); }
	public String getEscCkbCyoku3	() { return getCheckBoxChecked(ckbCyoku3	); }
	public String getEscCkbHoka1	() { return getCheckBoxChecked(ckbHoka1		); }
	public String getEscCkbHoka2	() { return getCheckBoxChecked(ckbHoka2		); }
	public String getEscCkbHoka3	() { return getCheckBoxChecked(ckbHoka3		); }
	public String getEscCkbHoka4	() { return getCheckBoxChecked(ckbHoka4		); }
	public String getEscCkbHoka5	() { return getCheckBoxChecked(ckbHoka5		); }

	public String getEscLblActualHour		() { return escapeHTML(lblActualHour		); }
	public String getEscLblActualMin		() { return escapeHTML(lblActualMin			); }
	public String getEscLblApprovalComment	() { return escapeHTML(lblApprovalComment	); }

	public void setLblActualHour		(String lblActualHour		){ this.lblActualHour		= lblActualHour		; }
	public void setLblActualMin		(String lblActualMin		){ this.lblActualMin		= lblActualMin		; }
	public void setLblApprovalComment	(String lblApprovalComment	){ this.lblApprovalComment	= lblApprovalComment; }

	public String[][] getAryAllowance() { return aryAllowance.clone(); }

}
